function [a]=sens_plot4a(skt,dsr,n,nds);
%function [a]=sens_plot4(skt,dsr,n,nds);
% Ian Stothers May 2018
  if (nargin==1)
    dsr=100;
     n=1000;
     nds=n;
  end

  fbw=1/dsr;
  pkg load signal;
  ntaps=3/fbw;
  ntaps=(floor(ntaps/2)*2)+1;
  bb=fir1(ntaps-1,fbw);
  aa=1;
 % [bb,aa]=butter(2,fbw);
  sr=1000.0; %sample rate
  sp=1/sr;
  ds_sp=sp*dsr;  %down sample sample rate
  
sinlength=10000.0/32768.0;
[a,ptr]=GetSensData1(skt,2);
[a,ptr]=GetSensData1(skt,ptr);

  idx=find(a>32767.0);
  msa=max(size(a));
  a(idx)=a(idx)-65536;
  a=a*sinlength;

pos=mean(a)*ones(1,n);
[fpos,sf]=filter(bb,aa,pos);
ppos=[ pos' fpos'];

figure(1);
clf;
snum=1:max(size(pos));
t=(snum-1)'*sp;
numsamps=max(snum);
subplot(211)
phdl=plot(t,ppos);
s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
s=[s sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)))];
ylabel('um');
xlabel('Time (Secs)')
thdl=title(s);
grid on;


ds_pos=mean(pos)*ones(1,nds);
ds_snum=1:max(size(ds_pos));
ds_t=(ds_snum-1)'*ds_sp;
subplot(212)
ds_phdl=plot(ds_t,ds_pos);
ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(ds_pos),sqrt(var(ds_pos)));
ylabel('um');
xlabel('Time (Secs)')
ds_thdl=title(ds_s);
grid on;


while (size(kbhit(1))(1)<1) 
  [a,ptr]=GetSensData1(skt,ptr);
  if (min(size(a))>0)
   idx=find(a>32767.0);
   msa=max(size(a));
   a(idx)=a(idx)-65536;
   a=a*sinlength;
   [fa,sf]=filter(bb,aa,a,sf);
   pos=[pos((msa+1):end) a];
   if(min(size(fa))>0)
    fpos=[fpos((msa+1):end) fa];
  
    idx=(1:msa)+numsamps;
    numsamps=numsamps+msa;
    idx=find(rem(idx,dsr)==0);
    ds_a=fa(idx);
    if(min(size(ds_a))>0)
     msdsa=max(size(ds_a));
     ds_pos=[ds_pos((msdsa+1):end) ds_a];
     ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(ds_pos),sqrt(var(ds_pos)));
     set(ds_phdl,'ydata',ds_pos');
  if (max(size(ds_pos))~=100) keyboard end
      set(ds_thdl,'string',ds_s);
     end 
   end
   s=sprintf('un-filtered mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
   s=[s sprintf('       filtered mean pos= %2.4fum  rms=%2.4fum',mean(fpos),sqrt(var(fpos)))];
   set(thdl,'string',s);
   set(phdl(1),'ydata',pos');
   set(phdl(2),'ydata',fpos');
   drawnow;
  end
end
  